<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('App\Models\Customer');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\OrderCategory');
    }

    public function professional()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function logs()
    {
        return $this->morphMany('App\Models\Log');
    }

    public function events()
    {
        return $this->morphMany('App\Models\Event');
    }

}